import React from 'react';
import { render, screen, waitFor, cleanup } from '@testing-library/react/pure';
import { Main } from './Main';

const mockFetchMethod = jest.fn();
const mockSetBaseUrl = jest.fn();
const mockSetExtendedParams = jest.fn();

jest.mock('components/Table/services/TableController', () => {
  return {
    TableController: class {
      tableData: {};
      fetch = mockFetchMethod;
      setExtendedQueryParams = mockSetExtendedParams;
      setBaseUrl = (url) => {
        mockSetBaseUrl(url);
        return this;
      };
    },
  };
});

jest.mock('components/Table/TableEditable', () => {
  return {
    TableEditable: () => <div>MockTable</div>,
  };
});

describe('DoneActivities/Main', () => {
  afterEach(() => {
    jest.clearAllMocks();
    cleanup();
  });

  it('renders activities table', () => {
    render(<Main url="/table?" />);
    expect(mockSetBaseUrl).toBeCalledTimes(1);
    expect(mockSetBaseUrl).toBeCalledWith('/table?');
    expect(mockFetchMethod).toBeCalledTimes(1);
    waitFor(() => {
      expect(screen.getByText('MockTable')).toBeInTheDocument();
    });
  });
});
