import React, { FC } from 'react';
import { LayoutProps } from './Layout.types';
import css from './Layout.module.css';

export const Layout: FC<LayoutProps> = ({ sidebar, main }) => {
  return (
    <div className={css.Layout}>
      {sidebar && <aside className={css.Layout__sidebar}>{sidebar}</aside>}
      {main && <main className={css.Layout__main}>{main}</main>}
    </div>
  );
};
