import React, { FC, useState, useEffect } from 'react';
import { config } from 'services/Config';
import { LinkTabs, LinkTab, ThemeType } from 'lego/components/Tabs';
import { DynamicallyModalForm } from 'components/DynamicallyModalForm';
import { Todos } from './Todos';
import { Calendar } from './Calendar';
import { ROUTE_PATH, REFRESH_INTERVAL } from './constants';
import css from './MeetingsPage.module.css';
import { View } from './Calendar/Sidebar/Sidebar.types';
import { useRefreshSubject } from './RefreshContext';
import { DoneActivities } from './DoneActivities';
import { ActivitiesPage } from './ActivitiesPage';

export const MeetingsPage: FC = () => {
  const [date, setDate] = useState(new Date());
  const refreshSubject = useRefreshSubject();
  const [calendarView, setCalendarView] = useState<View>('day');

  useEffect(() => {
    const intervalId = setInterval(() => {
      refreshSubject.next({ type: 'ScheduledRefresh' });
    }, REFRESH_INTERVAL);

    return () => {
      clearInterval(intervalId);
    };
  }, []);

  const todosTabUrl = `${ROUTE_PATH}/todos`;

  if (config.value.features.newActivitiesDesign) {
    return <ActivitiesPage date={date} setDate={setDate} />;
  }

  return (
    <>
      <LinkTabs
        theme={ThemeType.Icon}
        className={css.MeetingsPage}
        classNameHeader={css.TabsHeader}
        redirectUrl={todosTabUrl}
      >
        <LinkTab title="Дела на день" path={todosTabUrl} className={css.MeetingsPage__tab}>
          <Todos date={date} onDateChange={setDate} />
        </LinkTab>
        <LinkTab
          title="Календарь"
          path={`${ROUTE_PATH}/calendar`}
          className={css.MeetingsPage__tab}
        >
          <Calendar
            date={date}
            onDateChange={setDate}
            calendarView={calendarView}
            onCalendarView={setCalendarView}
          />
        </LinkTab>
        {config.value.features.activityTab ? (
          <LinkTab title="Совершённые активности" path={`${ROUTE_PATH}/feed`}>
            <DoneActivities />
          </LinkTab>
        ) : (
          undefined
        )}
      </LinkTabs>
      <DynamicallyModalForm />
    </>
  );
};
