import React, { createContext, useContext, FC, useState, useEffect } from 'react';
import { Subject } from 'rxjs';

export interface UpdateEvent {
  type: 'UpdateTable' | 'ChangeDate' | 'CreateActivity' | 'UpdateEvent' | 'ScheduledRefresh';
  payload: unknown;
}

export const refreshContext = createContext((null as unknown) as Subject<unknown>);
export const Consumer = refreshContext.Consumer;
export const Provider = refreshContext.Provider;

export const StatefulProvider: FC = ({ children }) => {
  const [refreshSubject] = useState(new Subject<UpdateEvent | undefined>());
  useEffect(
    () => () => {
      if (refreshSubject) {
        refreshSubject.unsubscribe();
      }
    },
    [],
  );

  return <Provider value={refreshSubject}>{children}</Provider>;
};
export const useRefreshSubject = () => useContext(refreshContext);
