import { get } from 'api/common';
import Bluebird from 'bluebird';
import { FetchDatesResponse } from './Sidebar.types';

export const createDateKey = (date: Date | string): string => {
  if (typeof date === 'string') {
    date = new Date(date);
  }
  return `${date.getFullYear()}-${date.getMonth()}-${date.getDate()}`;
};

export const fetchDates = (range: [Date, Date]): Bluebird<FetchDatesResponse> => {
  return get({
    url: '/manager-feed/calendar/dates',
    data: {
      fromDate: range[0].toISOString(),
      toDate: range[1].toISOString(),
    },
  });
};
