import React, { FC } from 'react';
import { startOfDay, endOfDay } from 'date-fns';
import { Calendar } from 'modules/meetings/ActivitiesPage/Calendar';
import { TodoTable } from '../TodoTable';
import { dateCaption } from './Main.utils';
import { MainProps } from './Main.types';
import css from './Main.module.css';
import { TABLE_SOURCE_URL } from './Main.constants';

export const Main: FC<MainProps> = ({ date }) => {
  const extendedQueryParams = {
    FromDate: startOfDay(date).toISOString(),
    ToDate: endOfDay(date).toISOString(),
  };

  return (
    <div className={css.Main}>
      <header className={css.Main__header}>
        <h2 className={css.Main__title}>{dateCaption(date)}</h2>
      </header>

      <div className={css.Main__content}>
        <div className={css.Main__table}>
          <TodoTable date={date} url={TABLE_SOURCE_URL} extendedQueryParams={extendedQueryParams} />
        </div>
        <div className={css.Main__calendarWrap}>
          <Calendar className={css.Main__calendar} date={date} view="day" />
        </div>
      </div>
    </div>
  );
};
