import { isToday, isTomorrow, isYesterday } from 'date-fns';

export const dateCaption = (date: Date): string => {
  if (isToday(date)) {
    return 'Сегодня';
  }

  if (isTomorrow(date)) {
    return 'Завтра';
  }

  if (isYesterday(date)) {
    return 'Вчера';
  }

  return date.toLocaleDateString('ru');
};
