import React, { FC, memo } from 'react';
import { Layout } from '../Layout';
import { TodosProps } from './Todos.types';
import { Sidebar } from '../Sidebar';
import { Main } from './Main';

export const Todos: FC<TodosProps> = memo(({ date, onDateChange }) => {
  return (
    <Layout
      sidebar={<Sidebar date={date} onDateChange={onDateChange} />}
      main={<Main date={date} />}
    />
  );
});
