import { get } from 'api/common';
import { Event } from 'components/Calendar/Event/Event.types';
import Bluebird from 'bluebird';

export const fetchEvents = (range: [Date, Date]): Bluebird<Event[]> => {
  return get({
    url: '/manager-feed/activity/calendar',
    data: {
      fromDate: range[0].toISOString(),
      toDate: range[1].toISOString(),
    },
  })
    .then((response) => response.items || [])
    .then((events) => {
      const mappedEvents = events.map((event) => {
        const { fromDate, toDate, title, ...rest } = event;
        return {
          start: new Date(event.fromDate),
          end: new Date(event.toDate),
          title: event.title,
          ...rest,
        };
      });

      return mappedEvents;
    });
};
