import { MetrikaParams, UserParams } from './types';
import StoreCreator from './components/Store';
import initMetrika from './yaMetrika';

export class Metrika {
  private readonly COUNT_NUMBER: number;

  private store: MetrikaParams = {};

  private ym: Ym;

  public Store = StoreCreator((prevStore, nextStore) => {
    const params = Object.keys(nextStore);
    if (!params.length) {
      this.setStore();
      return;
    }

    const filteredStore = params.reduce<MetrikaParams>((acc, param) => {
      if (prevStore[param] !== nextStore[param]) {
        acc[param] = nextStore[param];
      }

      return acc;
    }, {});

    this.setStore(filteredStore);
  });

  public constructor(count: number, funcToCall: Ym) {
    this.COUNT_NUMBER = count;
    this.ym = funcToCall;
  }

  start() {
    initMetrika();
  }

  public reachGoal = (goal: string, extraParams?: MetrikaParams): void => {
    this.ym(this.COUNT_NUMBER, 'reachGoal', goal, {
      ...this.store,
      ...extraParams,
    });
  };

  public setUserId = (id: string): void => {
    this.ym(this.COUNT_NUMBER, 'setUserID', id);
  };

  public userParams = <P>(params: UserParams<P>): void => {
    this.ym(this.COUNT_NUMBER, 'userParams', params);
  };

  private setStore = (nextStore?: MetrikaParams): void => {
    if (nextStore == null) {
      this.store = {};
      return;
    }

    this.store = {
      ...this.store,
      ...nextStore,
    };
  };
}

const metrika = new Metrika(38634760, window.ym);

export default metrika;
