import React from 'react';
import { MetrikaParams } from '../types';

type OnChange = (prevStore: MetrikaParams, nextStore: MetrikaParams) => void;
export default (onChange: OnChange): React.ComponentClass<MetrikaParams> =>
  class Store extends React.Component<MetrikaParams> {
    public componentDidMount(): void {
      onChange({}, this.props);
    }

    public componentDidUpdate(prevProps: MetrikaParams): void {
      onChange(prevProps, this.props);
    }

    public componentWillUnmount(): void {
      onChange(this.props, {});
    }

    public render(): React.ReactNode {
      return null;
    }
  };
