import React from 'react';
import { Field } from 'redux-form';

export interface Props {
  theme: {
    row?: string;
    field?: string;
    input?: string;
    label?: string;
  };
  component: any;
  showPlaceholder: boolean;
  name: string;

  getValue?: (value: any) => any;
  label?: string;
}

const CustomField: React.FC<Props> = props => {
  const { theme = {}, component, showPlaceholder, name, label } = props;

  return (
    <div className={theme.row}>
      {!!label && <span className={theme.label}>{label}</span>}
      <Field
        size="m"
        className={theme.field}
        componentClassName={theme.input}
        id={`customField_${name}`}
        name={name}
        component={component}
        showPlaceholder={showPlaceholder}
      />
    </div>
  );
};

export default CustomField;
