import * as React from 'react';
import DropdownMenu from 'lego/components/DropdownMenu';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Macros.i18n';

const i18nMacros = createI18N(keyset)('macros');

interface Props {
  ckeditor?: {
    mode: string;

    getData: () => string;
    setData: (data: string) => void;
    insertHtml: (value: string) => void;
  };

  macros: string[];
}

class Macros extends React.Component<Props> {
  public static defaultProps = {
    macros: [],
  };

  private onChange = (event: React.MouseEvent, value: string): void => {
    const { ckeditor } = this.props;

    if (!ckeditor) {
      return;
    }

    if (ckeditor.mode === 'source') {
      ckeditor.setData(value + ckeditor.getData());
    } else {
      ckeditor.insertHtml(value);
    }
  };

  public render() {
    const { macros } = this.props;

    const items = macros.map(item => ({ val: item, text: item }));

    return (
      <DropdownMenu
        onClick={this.onChange}
        size="s"
        disabled={!this.props.ckeditor}
        text={i18nMacros}
        maxHeight={400}
        items={items}
      />
    );
  }
}

export default Macros;
