import { compose } from 'redux';
import MailFormBase, { Fields } from './MailFormBase';
import withAutoSave from './withAutoSave';
import withTemplate from './withTemplate';
import withSelfData from './withSelfData';
import withInitSignature from './withInitSignature';
import { Props as CustomFieldProps } from './CustomField';
import { CustomSendButton } from './types';

export interface CommonProps {
  fields: Fields;
  name: string;
  loadOnMount: boolean;
  loadDraft: (args: any) => Promise<any>;
  loadReply: (args: any) => Promise<any>;
  loadNew: (args: any) => Promise<any>;

  customSendButtons?: CustomSendButton[];
  className?: string;
  isShowCancel?: boolean;
  isAutoSave?: boolean;
  location?: string;
  issueId?: number;
  // TODO: refactoring isInternalMail
  isInternalMail?: boolean;
  customFieldsTop?: CustomFieldProps[];
  EmailInput?: React.ReactType<any>;
  isPreventUnload?: boolean;
}

export default compose<React.ComponentType<CommonProps>>(
  withSelfData,
  withTemplate,
  withInitSignature,
  withAutoSave(),
)(MailFormBase);
