import React from 'react';
import { NotificationItem, NotificationItemProps } from 'modules/notificationsUI';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Notification.i18n';
import DelayedDate from '../DelayedDate';

const i18n = createI18N(keyset);
const i18nWillBeSend = i18n('willBeSend');
const i18nEmailSent = i18n('emailSent');
const i18nDraftSaved = i18n('draftSaved');

interface Props extends NotificationItemProps {
  args: {
    send?: boolean;
    delayedDate?: string;
  };
}

const Notification: React.FC<Props> = (props) => {
  let text: React.ReactNode = '';
  const { args } = props;
  if (args.send) {
    if (args.delayedDate) {
      text = (
        <span>
          {i18nWillBeSend}
          <DelayedDate delayedDate={args.delayedDate} />
        </span>
      );
    } else {
      text = i18nEmailSent;
    }
  } else {
    text = i18nDraftSaved;
  }

  return <NotificationItem {...props} text={text} />;
};

export default Notification;
