import * as React from 'react';
import SignatureEditor, { Signature } from '../utils/SignatureEditor';

interface Data {
  body?: string;
}

export interface Props {
  isLoad: boolean;
  templates?: {
    signatures?: Signature[];
  };
  initialValues?: Data;
  type: string;
}

const withInitSignature = <T extends Props>(WrappedComponent: React.ComponentType<T>) => {
  const InitSignature = (props: T) => {
    const { isLoad, templates, initialValues, type } = props;

    let patchedInitialValues = initialValues;
    if (type !== 'draft' && isLoad && templates && templates.signatures && initialValues) {
      const signatureEditor = new SignatureEditor(templates.signatures);

      const updatedBody = signatureEditor.insertSignatureHtml(
        initialValues.body || '',
        signatureEditor.defaultSignatureId,
      );

      patchedInitialValues = { ...initialValues, body: updatedBody };
    }

    return <WrappedComponent {...props} initialValues={patchedInitialValues} />;
  };

  return InitSignature;
};

export default withInitSignature;
