import { connect } from 'react-redux';
import { formValueSelector } from 'redux-form';
import get from 'lodash/get';
import { getState } from '../selectors';
import { actions as sliceActions, Template, Signature } from '../newMailSlice';

const { loadTemplates, destroy } = sliceActions;

export interface Props {
  name: string;
  resizeHash: string;
  location?: string;
  issueId?: number;
  isInternalMail?: boolean;

  isLoad?: boolean;
}

type MapState = (
  state: {},
  props: Props,
) => {
  form: string;
  templates: {
    templates: Template[];
    signatures: Signature[];
  };
  isLoad: boolean;
  resizeHash: string;
};

type MapDispatch = (
  dispatch: any,
  props: Props,
) => {
  loadTemplates: () => void;
};

const mapState: MapState = (state, props) => {
  const mailState = getState(state, props.name) || {};
  const formDataSelector = formValueSelector(props.name);

  return {
    form: props.name,
    templates: get(mailState, 'templates'),
    isLoad: !!(mailState.isLoadTemplates && props.isLoad),
    resizeHash: `${get(formDataSelector(state, 'files'), 'files.length', 0)}${props.resizeHash}`,
  };
};

const mapDispatch: MapDispatch = (dispatch, props) => ({
  // dirty fix location from react-router for new mail
  // https://st.yandex-team.ru/CRM-8651#5dd3fb41122154001cb250cf
  // https://st.yandex-team.ru/CRM-9018#5e340c515f7882236b88d52a
  loadTemplates: () =>
    dispatch(
      loadTemplates(
        props.name,
        // беку нужно отфильтровывать допустимые значения
        props.location === 'call' || props.location === 'ticket' ? props.location : undefined,
        props.issueId,
        props.isInternalMail,
      ),
    ),
  destroyNewMail: () => dispatch(destroy(props.name, undefined)),
});

export default connect<{}, {}, Props>(mapState, mapDispatch);
