import clearSignature from 'utils/mail/clearSignature';
import { File } from 'components/FilesList/types';
import { Tag } from 'types';
import { Props as CustomFieldProps } from './components/CustomField';

interface Values {
  from: string;

  TagIds?: Tag[];
  body?: string;
  files?: File[];
  containerId?: number;
  importance?: any;
  send?: boolean;
  subject?: string;

  action?: string;
}

interface Props {
  customFieldsBottom: CustomFieldProps[];
  customFieldsTop: CustomFieldProps[];

  froms?: string[];
  clearHtmlOnSend?: boolean;
}

interface ReturnValues {
  body?: string;
  containerId?: number;
  TagIds?: number[];
  from?: string;
  importance?: any;
  send?: boolean;
  subject?: string;

  action?: string;
}

export default (values: Values, props: Props, isPlain: boolean): ReturnValues => {
  const filteredValues: Values = { ...values };

  // body
  // чистим только html
  if (props.clearHtmlOnSend && values.send && !isPlain) {
    filteredValues.body = clearSignature(filteredValues.body || '');
  }

  // custom fields
  let customFieldValues = {};
  const customFields = props.customFieldsTop.concat(props.customFieldsBottom);
  customFields.forEach((field) => {
    const formFieldValue = values[field.name];
    delete filteredValues[field.name];
    if (typeof field.getValue === 'function') {
      customFieldValues = { ...customFieldValues, ...field.getValue(formFieldValue) };
    } else {
      customFieldValues[field.name] = formFieldValue;
    }
  });

  // tags
  const tags = filteredValues.TagIds;
  delete filteredValues.TagIds;
  const formattedTags: number[] = [];
  if (tags && tags.length) {
    tags.forEach((item) => {
      formattedTags.push(item.id);
    });
  }

  delete filteredValues.files;

  return {
    ...filteredValues,
    TagIds: formattedTags,
    from: props.froms && props.froms[values.from],
    ...customFieldValues,
  };
};
