import { get, jsonApiCall } from 'api/common';
import { actions as moduleCountersActions, modules } from 'reducers/moduleCountersSlice';
import { actions as ilActions } from 'containers/InfiniteList';
import * as aTypes from './actionTypes';
import { NAME } from './constants';
import listUpdater from './listUpdater';

export const show = () => ({ type: aTypes.SHOW });
export const hide = () => ({ type: aTypes.HIDE });

export const load = (args) => (dispatch) =>
  get({
    url: '/view/notification/list',
    data: args,
    global: false,
  }).then((data = {}) => {
    dispatch(
      moduleCountersActions.set({
        [modules.notifications]: parseInt(data.unreadCount, 10),
      }),
    );
    return data;
  });

export const loadCount = () => (dispatch) =>
  get({
    url: '/view/notification/list',
    data: {
      counts: true,
    },
    global: false,
  }).then((data) => {
    dispatch(
      moduleCountersActions.set({
        [modules.notifications]: parseInt(data.unreadCount, 10),
      }),
    );
    return null;
  });

export const readAll = () => (dispatch) => {
  if (!global.confirm('Отметить все уведомления прочитанными?')) {
    return null;
  }

  dispatch({ type: aTypes.READ_ALL_REQUEST });
  return jsonApiCall({ url: '/actions/notification/read_all' })
    .then(() => {
      dispatch({ type: aTypes.READ_ALL_RECEIVE });
      return dispatch(ilActions.refresh(NAME));
    })
    .catch((e) => {
      dispatch({ type: aTypes.READ_ALL_FAIL });
      throw e;
    });
};

export const read = (notificationId, flag) => (dispatch) =>
  jsonApiCall({
    url: '/actions/notification/toggle',
    data: {
      id: notificationId,
      isNew: flag,
    },
  }).then(() => {
    if (flag) {
      dispatch(moduleCountersActions.increment(modules.notifications));
    } else {
      dispatch(moduleCountersActions.decrement(modules.notifications));
    }

    dispatch(ilActions.update(NAME, listUpdater(notificationId, flag), true));

    return null;
  });

export const changeFilter = (payload) => ({ type: aTypes.CHANGE_FILTER, payload });
