import React from 'react';
import ReactDOM from 'react-dom';
import PropTypes from 'prop-types';
import memoize from 'lodash/memoize';
import css from './Layout.modules.scss';
import Notifications from '../Notifications';

const loadMemoized = memoize((filter, load) => (args) => load({ ...filter, ...args }));
loadMemoized.Cache = WeakMap;

const Layout = (props) => {
  const { isShow, load, hide, readAll, unreadCount, changeFilter, filter } = props;

  if (!isShow) {
    return null;
  }

  return ReactDOM.createPortal(
    <div className={css.Layout}>
      <Notifications
        className={css.Layout__notifications}
        load={loadMemoized(filter, load)}
        filter={filter}
        hide={hide}
        visible={isShow}
        onClose={hide}
        readAll={readAll}
        changeFilter={changeFilter}
        unreadCount={unreadCount}
      />
    </div>,
    document.getElementById('container'),
  );
};

Layout.propTypes = {
  isShow: PropTypes.bool,
  load: PropTypes.func.isRequired,
  hide: PropTypes.func.isRequired,
  readAll: PropTypes.func.isRequired,
  changeFilter: PropTypes.func.isRequired,
  unreadCount: PropTypes.number,
};

Layout.defaultProps = {
  isShow: false,
  unreadCount: 0,
};

export default Layout;
