import React from 'react';
import PropTypes from 'prop-types';
import { Field, Form } from 'react-final-form';
import Select from 'lego/final-form/Select';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import css from './Header.modules.scss';

const SOURCE = [
  {
    value: 'All',
    content: 'Все',
  },
  {
    value: 'Issues',
    content: 'Задачи',
  },
  {
    value: 'Approval',
    content: 'Утверждения',
  },
  {
    value: 'Tickets',
    content: 'Тикеты',
  },
  {
    value: 'External',
    content: 'Внешние сервисы',
  },
];

const STATE = [
  {
    value: 'All',
    content: 'Любой',
  },
  {
    value: 'Read',
    content: 'Прочитано',
  },
  {
    value: 'Unread',
    content: 'Не прочитано',
  },
];

const Header = ({ readAll, unreadCount, initialValues, changeFilter }) => {
  return (
    <Form validate={changeFilter} initialValues={initialValues} onSubmit={() => {}}>
      {() => (
        <div className={css.b}>
          <div className={cx(css.b__col, css.b__col_max)}>
            <div className={css.b__label}>Источник</div>
            <Field
              component={Select}
              options={SOURCE}
              name="source"
              hasEmptyValue={false}
              size="xs"
            />
          </div>
          <div className={cx(css.b__col, css.b__col_max)}>
            <div className={css.b__label}>Статус</div>
            <Field
              component={Select}
              options={STATE}
              name="state"
              hasEmptyValue={false}
              size="xs"
            />
          </div>
          <div className={css.b__split} />
          <div className={css.b__col}>
            <Button onClick={readAll} disabled={!unreadCount} size="xs" view="action">
              Прочитать все
            </Button>
          </div>
        </div>
      )}
    </Form>
  );
};

Header.propTypes = {
  readAll: PropTypes.func.isRequired,
  unreadCount: PropTypes.number,
};

Header.defaultProps = {
  unreadCount: 0,
};

export default Header;
