import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import StaffCard from 'components/StaffCard';
import cx from 'classnames';
import css from './Notification.modules.scss';

const Notification = props => {
  const {
    className,
    data: { date, author, isNew, body, title },
    read,
  } = props;

  return (
    <div className={cx(className, css.Notification)}>
      <div className={cx(css.Notification__wrap, { [css.Notification__wrap_new]: isNew })}>
        <div className={css.Notification__left}>
          <button
            className={isNew ? css.Notification__new_true : css.Notification__new_false}
            onClick={read}
            type="button"
          />
        </div>
        <div className={css.Notification__right}>
          <div className={css.Notification__header}>
            <span className={css.Notification__titleRow}>
              <span className={css.Notification__title}>{title}</span>
            </span>
            <span className={css.Notification__date}>
              <FormattedDate
                value={new Date(date)}
                year="numeric"
                month="numeric"
                day="numeric"
                hour="numeric"
                minute="numeric"
              />
            </span>
          </div>
          <div>
            <span>Автор: </span>
            <StaffCard user={author} />
          </div>
          <div className={css.Notification__body} dangerouslySetInnerHTML={{ __html: body }} />
        </div>
      </div>
    </div>
  );
};

Notification.propTypes = {
  className: PropTypes.string,
  data: PropTypes.shape({
    date: PropTypes.string.isRequired,
    author: PropTypes.instanceOf(Object).isRequired,
    isNew: PropTypes.bool.isRequired,
    body: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
  }).isRequired,
  read: PropTypes.func.isRequired,
};

Notification.defaultProps = {
  className: undefined,
};

export default Notification;
