import React from 'react';
import PropTypes from 'prop-types';

const NotificationTarget = props => {
  const {
    target: { eid, title },
  } = props;

  return (
    <a href={`#/request/${eid}`} target="_blank" rel="noopener noreferrer">
      {title}
    </a>
  );
};

NotificationTarget.propTypes = {
  target: PropTypes.shape({
    eid: PropTypes.number.isRequired,
    etype: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
  }).isRequired,
};

export default NotificationTarget;
