import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { config } from 'services/Config';
import modalRelation from 'utils/modalRelation';
import { InfiniteListView } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import Notification from './ConnectedNotification';
import Header from './Header';
import { NAME } from '../../constants';
import css from './Notifications.modules.scss';

const itemProps = {
  className: css.Notifications__item,
};

const empty = <Empty text="Уведомлений нет" icon="" />;

const Notifications = React.forwardRef(
  ({ className, load, readAll, unreadCount, changeFilter, filter }, ref) => (
    <div ref={ref} className={cx(className, css.Notifications)}>
      <Header
        readAll={readAll}
        unreadCount={unreadCount}
        changeFilter={changeFilter}
        initialValues={filter}
      />
      <InfiniteListView
        initialUpdateInterval={config.value.config.intervals.viewNotificationList}
        name={NAME}
        component={Notification}
        onLoad={load}
        loadOnMount
        className={css.Notifications__list}
        classNameScrollNode={css.Notifications__listScrollNode}
        itemProps={itemProps}
        emptyComponent={empty}
        reloadOnLoadUpdate
      />
    </div>
  ),
);

Notifications.propTypes = {
  load: PropTypes.func.isRequired,
  readAll: PropTypes.func.isRequired,
  className: PropTypes.string,
  changeFilter: PropTypes.func.isRequired,
  unreadCount: PropTypes.number,
  filter: PropTypes.instanceOf(Object),
};

Notifications.defaultProps = {
  unreadCount: 0,
  filter: undefined,
  className: undefined,
};

export default modalRelation(Notifications);
