import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import { config } from 'services/Config';
import { AdaptiveIntervalByTabVisibility } from 'services/AdaptiveInterval';
import Toggle from './Toggle';
import dataConnector from '../dataConnector';

class ToggleContoller extends React.Component {
  static propTypes = {
    isShow: PropTypes.bool,
    loadCount: PropTypes.func.isRequired,
  };

  static defaultProps = {
    isShow: false,
  };

  componentDidMount() {
    this.loadCount();
    this.setTimer();
  }

  componentWillReceiveProps(nextProps) {
    const isShowNext = nextProps.isShow;

    if (isShowNext !== this.props.isShow) {
      if (isShowNext) {
        this.clearTimer();
      } else {
        this.setTimer();
      }
    }
  }

  componentWillUnmount() {
    this.clearTimer();
  }

  setTimer() {
    this.interval = new AdaptiveIntervalByTabVisibility(
      this.loadCount,
      config.value.config.intervals.viewNotificationList,
    );
  }

  loadCount = () => {
    if (!this.props.isShow) {
      this.props.loadCount();
    }
  };

  clearTimer() {
    this.interval.destroy();
  }

  render() {
    return createElement(Toggle, this.props);
  }
}

export default dataConnector(ToggleContoller);
