import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import ModuleIcon from 'components/ModuleIcon';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './Toggle.modules.scss';
import { NOTIFICATION_TOGGLE_CLASS } from '../../constants';

const Toggle = (props) => {
  const {
    className,
    classNameActive,
    show,
    hide,
    unreadCount,
    isShow,
    // // https://st.yandex-team.ru/CRM-15295
    changeFilter,
    ...passPropsThrough
  } = props;

  delete passPropsThrough.setUnreadCount;
  delete passPropsThrough.loadCount;
  delete passPropsThrough.readAll;
  delete passPropsThrough.load;
  delete passPropsThrough.read;

  return (
    <button
      className={cx(css.Toggle, NOTIFICATION_TOGGLE_CLASS, className, {
        [classNameActive]: isShow,
      })}
      onClick={isShow ? hide : show}
      title="Уведомления"
      type="button"
      {...passPropsThrough}
    >
      <ModuleIcon
        count={unreadCount}
        icon={(cls) => <Icon className={cls} svg="bell" svgSize="l" />}
      />
    </button>
  );
};

Toggle.propTypes = {
  className: PropTypes.string,
  classNameActive: PropTypes.string,
  show: PropTypes.func.isRequired,
  hide: PropTypes.func.isRequired,
  isShow: PropTypes.bool,
  unreadCount: PropTypes.number,
};

Toggle.defaultProps = {
  className: undefined,
  classNameActive: undefined,
  isShow: false,
  unreadCount: 0,
};

export default Toggle;
