import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';
import * as aTypes from './actionTypes';

const INIT = {
  filter: {
    source: 'All',
    state: 'All',
  },
};

const behaviors = {
  [aTypes.SHOW](state) {
    return {
      ...state,
      isShow: true,
    };
  },
  [aTypes.HIDE](state) {
    return {
      ...state,
      isShow: false,
    };
  },
  [aTypes.READ_ALL_REQUEST](state) {
    return {
      ...state,
      isReadAllFetch: true,
    };
  },
  [aTypes.READ_ALL_RECEIVE](state) {
    return {
      ...state,
      isReadAllFetch: false,
    };
  },
  [aTypes.READ_ALL_FAIL](state) {
    return {
      ...state,
      isReadAllFetch: false,
    };
  },
  [aTypes.CHANGE_FILTER](state, { payload }) {
    return {
      ...state,
      filter: payload,
    };
  },
  LOCAL_STORAGE(state) {
    return {
      filter: state.filter,
    };
  },
};

export default reducerFactoryRaw(aTypes, behaviors, INIT);
