import * as aTypes from './actionTypes';

let itemId = 0;

export const clear = () => ({ type: aTypes.CLEAR });
export const push = (itemProps) => {
  let messageLevel = itemProps.theme;
  if (itemProps.level) {
    messageLevel = itemProps.level;
  }

  if (messageLevel === 'warn') {
    messageLevel = 'warning';
  }

  if (!itemProps.id) {
    itemId += 1;
  }
  const id = itemProps.id || itemId;
  return {
    type: aTypes.PUSH,
    payload: {
      ...itemProps,
      level: messageLevel,
      id,
    },
  };
};
export const close = (id) => ({ type: aTypes.CLOSE, payload: id });

export const toggle = (flag) => ({ type: aTypes.TOGGLE, payload: flag });
