import React from 'react';
import cx from 'classnames';
import { MessageLevel } from 'types/Message/MessageLevel';
import WordBreak from 'components/WordBreak';
import css from './NotificationItem.module.css';
import { ICON, TITLE } from './NotificationItem.config';
import { NotificationItemProps } from './NotificationItem.types';
import { NotificationItemActionAny } from './NotificationItemAction';

export class NotificationItem extends React.Component<NotificationItemProps> {
  public static defaultProps = {
    level: MessageLevel.Default,
    autoHideDuration: 4000,
    canClose: true,
  };

  private timer: number;

  public componentDidMount() {
    if (this.props.canClose && this.props.onClose && this.props.autoHideDuration) {
      this.timer = window.setTimeout(
        this.props.onClose,
        this.props.autoHideDuration,
        this.props.id,
      );
    }
  }

  public componentWillUnmount() {
    if (this.timer) {
      clearTimeout(this.timer);
    }
  }

  private handleClose = () => {
    this.props.onClose(this.props.id);
  };

  public render() {
    const { text, canClose, level } = this.props;

    return (
      <div className={cx(css.root, css[level])}>
        <div className={css.header}>
          {(ICON[this.props.level] || this.props.title) && (
            <div className={css.title}>
              {ICON[this.props.level] && <span className={css.icon}>{ICON[this.props.level]}</span>}
              {this.props.title || TITLE[this.props.level]}
            </div>
          )}
          <div className={css.actions}>
            {canClose && (
              <button type="button" onClick={this.handleClose}>
                <i className="material-icons">close</i>
              </button>
            )}
          </div>
        </div>
        <WordBreak className={css.body}>
          <div className={css.bodyWrap}>{text}</div>
        </WordBreak>
        {this.props.actions && (
          <div className={css.footer}>
            {this.props.actions.map((itemProps, index) => (
              <NotificationItemActionAny key={index} className={css.button} action={itemProps} />
            ))}
          </div>
        )}
      </div>
    );
  }
}
