import React, { FC } from 'react';
import { MessageActionType } from 'types/Message/MessageActionType';
import {
  NotificationItemActionAnyProps,
  NotificationItemActionSupportedProps,
  ActionTypeToRenderMap,
} from './NotificationItemActionAny.types';
import { NotificationItemActionButton } from './NotificationItemActionButton';
import { NotificationItemActionLink } from './NotificationItemActionLink';

function isMessageActionByScheme(
  props: NotificationItemActionAnyProps,
): props is NotificationItemActionSupportedProps {
  const action = props.action;
  return Boolean(action && typeof action === 'object' && 'type' in action);
}

const actionTypeToRender: ActionTypeToRenderMap = new Map();
actionTypeToRender.set(MessageActionType.Link, (props) => {
  return (
    <NotificationItemActionLink className={props.className} href={props.action.data.url}>
      {props.action.data.text}
    </NotificationItemActionLink>
  );
});

export const NotificationItemActionAny: FC<NotificationItemActionAnyProps> = (props) => {
  if (isMessageActionByScheme(props)) {
    const render = actionTypeToRender.get(props.action.type);

    if (!render) {
      return null;
    }

    return render(props);
  }

  return <NotificationItemActionButton className={props.className} {...props.action} />;
};
