import { ReactElement } from 'react';
import { MessageActionAny } from 'types/Message/MessageActionAny';
import { MessageActionType } from 'types/Message/MessageActionType';
import { MessageActionLink } from 'types/Message/MessageActionLink';

export type NotificationItemActionAnyDTO = MessageActionAny | unknown;

export interface NotificationItemActionProps<ActionDTO> {
  className?: string;
  action: ActionDTO;
}

export type NotificationItemActionAnyProps = NotificationItemActionProps<
  NotificationItemActionAnyDTO
>;

export type NotificationItemActionSupportedProps = NotificationItemActionProps<MessageActionAny>;

export interface NotificationItemActionPropsMap {
  [MessageActionType.Link]: NotificationItemActionProps<MessageActionLink>;
}

export type ActionTypeToRenderMap = Map<
  MessageActionType,
  (props: NotificationItemActionPropsMap[MessageActionType]) => ReactElement
>;
