import { connect } from 'react-redux';
import get from 'lodash/get';
import { NAME } from '../../constants';
import { Notifications as NotificationsBase } from './Notifications';
import { close, clear, toggle } from '../../actions';
import {
  NotificationsConnecteStateProps,
  NotificationsConnectedDispatchProps,
} from './Notifications.types';

const mapState = (state) => {
  const { itemsMap, itemsList, permanentItems, ...other } = get(state, `${NAME}`, {});
  let items;
  if (permanentItems) {
    items = Object.values(permanentItems);
  }
  if (itemsList) {
    items = [...(items || []), ...itemsList.map((id) => itemsMap[id])];
  }

  return {
    items,
    ...other,
  };
};

const mapDispatch = (dispatch) => ({
  close: (id) => dispatch(close(id)),
  closeAll: () => dispatch(clear()),
  toggle: (flag) => dispatch(toggle(flag)),
});

export const Notifications = connect<
  NotificationsConnecteStateProps,
  NotificationsConnectedDispatchProps
>(
  mapState,
  mapDispatch,
)(NotificationsBase);
