import { TransitionGroup, CSSTransition } from 'react-transition-group';
import React from 'react';
import cx from 'classnames';
import css from './Notifications.module.css';
import { NotificationItem } from '../NotificationItem';
import InjectView from '../../InjectView';
import { NotificationsProps } from './Notifications.types';
import { ANIM_CLASSNAMES, ANIM_TIMEOUT } from './Notifications.config';

export class Notifications extends React.Component<NotificationsProps> {
  public static defaultProps = {
    items: [],
    open: false,
  };

  public componentDidMount() {
    if (this.props.open) {
      document.addEventListener('click', this.handleClickOutSide);
    }
  }

  public componentWillReceiveProps(nextProps) {
    if (nextProps.open !== this.props.open) {
      if (nextProps.open) {
        document.addEventListener('click', this.handleClickOutSide);
      } else {
        document.removeEventListener('click', this.handleClickOutSide);
      }
    }
  }

  public componentWillUnmount() {
    if (this.props.closeAll) {
      this.props.closeAll();
    }

    document.removeEventListener('click', this.handleClickOutSide);
  }

  private handleClickOutSide = (e) => {
    if (!e.target.closest('.notifications_root')) {
      this.props.toggle(false);
    }
  };

  private handleCloseItem = (id: number) => {
    this.props.close(id);
  };

  public render() {
    const { items, open } = this.props;

    const filterItem = open ? items : items.filter((item) => !item?.close);

    return (
      <TransitionGroup className={cx(css.root, 'notifications_root')}>
        {filterItem.map((item) => {
          const Component =
            item.view && InjectView.views[item.view]
              ? InjectView.views[item.view]
              : NotificationItem;

          return (
            <CSSTransition key={item.id} timeout={ANIM_TIMEOUT} classNames={ANIM_CLASSNAMES}>
              <Component
                {...item}
                onClose={this.handleCloseItem}
                canClose={!open && !item.isPermanent}
              />
            </CSSTransition>
          );
        })}
      </TransitionGroup>
    );
  }
}
