import { useContext, useEffect, useCallback } from 'react';
import { batch } from 'react-redux';
import { MessageLevel } from 'types/Message/MessageLevel';
import { useDispatch } from 'react-redux';
import { notificationPlay } from 'modules/notificationsUI/notificationPlay';
import { XivaContext, XivaBackendEventType, XivaBackendEvents } from 'modules/xiva';
import { push } from '../../actions';

export const XivaConnector = () => {
  const xiva = useContext(XivaContext);
  const dispatch = useDispatch();

  const handleMessage = useCallback(
    (event: XivaBackendEvents[XivaBackendEventType.Message]) => {
      if (event.detail.messages) {
        batch(() => {
          event.detail.messages!.forEach((message) => {
            // TODO https://st.yandex-team.ru/CRM-12803
            dispatch(push({ ...message, level: MessageLevel[message.level] }));
            if (message.sound) {
              notificationPlay.play();
            }
          });
        });
      } else if (event.detail.message) {
        dispatch(push({ text: event.detail.message, level: MessageLevel.Warning }));
      }
    },
    [dispatch],
  );

  useEffect(() => {
    xiva.addEventListener(XivaBackendEventType.Message, handleMessage);

    return () => {
      xiva.removeEventListener(XivaBackendEventType.Message, handleMessage);
    };
  }, [handleMessage, xiva]);

  return null;
};
