import Immutable from 'immutable';
import { unv } from 'utils/common';
import * as aTypes from './actionTypes';

const behaviors = {
  [aTypes.CLEAR](state) {
    return state
      .delete('itemsMap')
      .delete('itemsList')
      .delete('permanentItems');
  },
  [aTypes.PUSH](state, { payload }) {
    let newState = state;
    if (payload.isPermanent) {
      return newState.update('permanentItems', (permanentItems) =>
        permanentItems ? permanentItems.set(payload.id, payload) : { [payload.id]: payload },
      );
    }
    const list = newState.get('itemsList');
    if (list && list.size === 10) {
      const itemId = list.first();
      newState = newState
        .deleteIn(['itemsMap', itemId.toString()])
        .update('itemsList', (itemsList) => itemsList.shift());
    }

    return newState
      .update('itemsMap', (itemsMap) =>
        itemsMap ? itemsMap.set(payload.id, payload) : { [payload.id]: payload },
      )
      .update('itemsList', (itemsList) => (itemsList ? itemsList.push(payload.id) : [payload.id]));
  },
  [aTypes.CLOSE](state, { payload }) {
    if (state.get('permanentItems')?.has(payload.toString())) {
      return state.deleteIn(['permanentItems', payload.toString()]);
    }
    return state.setIn(['itemsMap', payload.toString(), 'close'], true);
  },
  [aTypes.TOGGLE](state, { payload }) {
    return state
      .update('open', (open) => unv(payload, !open))
      .update(
        'itemsMap',
        (itemsMap) => itemsMap && itemsMap.map((item) => item.set('close', true)),
      );
  },
};

const reducer = (state = {}, action) => {
  const behavior = behaviors[action.type];
  return behavior ? behavior(Immutable.fromJS(state), action).toJS() : state;
};

export default reducer;
