// TODO: Задача на рефакторинг https://st.yandex-team.ru/CRM-10736
import React, { FC } from 'react';
import { Panel as PanelComponent, PanelProps } from '@crm/components/dist/Panel';
import { config } from 'services/Config';
import { dispatchUXEvent } from 'components/UXLogger';

export const Panel: FC<PanelProps> = (props) => {
  return (
    <PanelComponent
      {...props}
      isNewDesign={config.value.features.newDesignFilters || props.isNewDesign}
      onPanelStateChange={(data) => {
        dispatchUXEvent('panelStateChange', data);
      }}
    />
  );
};
