import React from 'react';
import { Position, Tone } from '@crm/components/dist/Panel';
import { storiesOf } from '@storybook/react';
import Panel from './index';

const style = {
  width: 500,
  height: 500,
  overflow: 'hidden',
  border: '1px solid black',
  marginBottom: 20,
  position: 'relative',
  display: 'flex',
  flexFlow: 'row nowrap',
} as React.CSSProperties;

const mainStyles = {
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  flex: 1,
};

const panels = [
  {
    id: 1,
    title: 'Panel_1',
    content: 'Panel_Content_1',
  },
  {
    id: 2,
    title: 'Panel_2',
    content: 'Panel_Content_2',
  },
];

storiesOf('Panel', module).add(
  'view',
  (): React.ReactElement => (
    <div>
      <div style={style}>
        <Panel
          name="issue/filters"
          position={Position.Left}
          defaultPin
          defaultPanelId={2}
          defaultSize={{
            width: 200,
          }}
          minWidth={100}
          maxWidth={300}
          panels={panels}
        />
        <div style={mainStyles}>Main</div>
      </div>
      <div style={style}>
        <div style={mainStyles}>Main</div>
        <Panel
          name="issue/filters"
          position={Position.Right}
          defaultPin
          defaultPanelId={2}
          defaultSize={{
            width: 200,
          }}
          minWidth={100}
          maxWidth={300}
          panels={panels}
          tone={Tone.Neowhite}
        />
      </div>
    </div>
  ),
);
