import { PanelModel } from 'services/DBProvider/Models';
import { getBindInstance } from 'services/DBProvider/Models/Models.utils';
import { actions } from 'entry/modules/initial/UiSettings/actions';

const panelModel = getBindInstance(PanelModel);

export const pin = (name, flag) => (dispatch) => {
  panelModel.then((model) => model.update({ panelId: name, pin: flag }));

  return dispatch(
    actions.setPanelPin({
      flag,
      meta: { name },
    }),
  );
};

export const setSettings = (name, payload) => {
  panelModel.then((model) =>
    model.update({ panelId: name, tabId: payload.panelId, pin: payload.pin }),
  );
  return actions.setPanelSettings({
    payload,
    meta: { name },
  });
};

export const setPanelId = (name, panelId, canToggle) => (dispatch) => {
  panelModel.then((model) => model.update({ panelId: name, tabId: panelId }));

  return dispatch(
    actions.setPanelId({
      payload: panelId,
      canToggle,
      meta: { name },
    }),
  );
};
