import { createSlice } from '@reduxjs/toolkit';
import toggleBooleanValue from 'utils/toggleBooleanValue';

export const panelUISlice = createSlice({
  name: 'panel',
  reducers: {
    setPanelPin: (state, { payload: { flag, meta } }) => {
      return {
        ...state,
        panel: {
          ...state.panel,
          [meta.name]: {
            ...state.panel[meta.name],
            pin: toggleBooleanValue(flag, state.panel[meta.name].pin),
          },
        },
      };
    },
    setPanelSettings: (state, { payload }) => {
      return {
        ...state,
        panel: {
          ...state.panel,
          [payload.meta.name]: payload.payload,
        },
      };
    },
    setPanelId: (state, { payload: { payload, canToggle = true, meta } }) => {
      return {
        ...state,
        panel: {
          ...state.panel,
          [meta.name]: {
            ...state.panel[meta.name],
            panelId: state.panel[meta.name].panelId === payload && canToggle ? 0 : payload,
          },
        },
      };
    },
  },
});

export default panelUISlice.reducer;
