import { CommonProps, PanelId, Position, Settings, Tone } from '@crm/components/dist/Panel';
import { Size } from '@crm/components/dist/Resizable';

export interface ConnectedState {
  pin?: boolean;
  panelId?: PanelId;
}

export interface ConnectedDispatch {
  setSettings: (payload: Settings) => void;
  setPanelId: (panelId: PanelId | null) => void;
}

export interface ConnectedProps extends Omit<CommonProps, 'size' | 'position' | 'tone'> {
  size?: Size;
  defaultPin?: boolean;
  defaultPanelId?: PanelId;
  position?: Position;
  tone?: Tone;
  forceNewDesign?: boolean;
}

export type IPanelContainerProps = ConnectedState & ConnectedDispatch & ConnectedProps;
