import { makeAutoObservable } from 'mobx';
import Bluebird from 'bluebird';
import { get } from 'api/common';
import { Tabs } from 'types/api/Tabs';

export class PersonalDashboardService {
  public data: Tabs['data'] = { tabs: [] };

  private loadPagePromise?: Bluebird<Tabs>;

  public constructor() {
    makeAutoObservable(this, { destroy: false });
  }

  public setData(data: Tabs) {
    this.data = data.data;
  }

  public loadPage() {
    this.destroy();
    this.loadPagePromise = get<Tabs>({ url: '/personalDashboard/tabs' }).then((data) => {
      this.setData(data);

      return data;
    });
  }

  public destroy() {
    if (this.loadPagePromise) {
      this.loadPagePromise.cancel();
    }
  }
}
