import React from 'react';
import { Router } from 'react-router-dom';
import { createMemoryHistory } from 'history';
import { worker } from './mocks/browser';
import { PersonalDashboard } from './PersonalDashboard';

const history = createMemoryHistory();

export default {
  title: 'PersonalDashboard',
  decorators: [
    (Story) => {
      // Reset request handlers added in individual stories.
      worker?.start();
      worker?.resetHandlers();
      return <Story />;
    },
  ],
};

export const Default = () => (
  <Router history={history}>
    <PersonalDashboard />
  </Router>
);
