import React, { FC, useEffect } from 'react';
import { observer } from 'mobx-react-lite';
import { LinkTab, LinkTabs } from 'lego/components/Tabs';
import { LayoutBuilderByScheme } from 'components/LayoutBuilderByScheme';
import { PersonalDashboardProps } from './PersonalDashboard.types';
import { injectService } from './injectService';
import css from './PersonalDashboard.module.css';
import { TabLogger } from './TabLogger';

export const PersonalDashboard = injectService(
  observer((({ personalDashboardService, url = '' }) => {
    useEffect(() => {
      personalDashboardService.loadPage();
    }, [personalDashboardService]);

    if (!personalDashboardService.data.tabs.length) {
      return null;
    }

    const firstTab = `${url}/${personalDashboardService.data.tabs[0].tabId}`;

    return (
      <LinkTabs
        className={css.PersonalDashboard}
        classNameHeader={css.PersonalDashboard__header}
        navigationTheme="start"
        redirectUrl={firstTab}
      >
        {personalDashboardService.data.tabs.map((tab) => (
          <LinkTab
            className={css.PersonalDashboard__tabContent}
            key={tab.tabId}
            path={`${url}/${tab.tabId}`}
            title={tab.tabCaption}
          >
            <LayoutBuilderByScheme blocks={tab.blocks} layout={tab.layout} />
            {tab && <TabLogger tab={tab} />}
          </LinkTab>
        ))}
      </LinkTabs>
    );
  }) as FC<PersonalDashboardProps>),
);
