import Rum from 'services/Rum';
import { FC, useEffect } from 'react';
import { TabLoggerProps } from './TabLogger.types';

export const TabLogger: FC<TabLoggerProps> = ({ tab }) => {
  useEffect(() => {
    Rum.sendTimeMark('personalDashboardTab', window.Ya.Rum.getTime(), {
      userId: window.USER_ID,
      tabCaption: tab.tabCaption,
      tabId: tab.tabId,
    });
  }, []);

  return null;
};
