/* TODO: https://st.yandex-team.ru/CRM-11930 */

import React, { useState, useEffect, ComponentType, PropsWithChildren } from 'react';
import { PersonalDashboardService } from './PersonalDashboard.service';

export const injectService = <P extends { personalDashboardService: PersonalDashboardService }>(
  WrappedComponent: ComponentType<P>,
) => {
  return function WithInjectService(props: PropsWithChildren<Omit<P, 'personalDashboardService'>>) {
    const [personalDashboardService] = useState(new PersonalDashboardService());

    useEffect(() => {
      return () => {
        personalDashboardService.destroy();
      };
    }, [personalDashboardService]);

    return (
      <WrappedComponent {...(props as P)} personalDashboardService={personalDashboardService} />
    );
  };
};
