import { rest } from 'msw';

export const handlers = [
  rest.get(`${window.CRM_SPACE_API_HOST}/personalDashboard/tabs`, (req, res, ctx) => {
    return res(
      ctx.json({
        data: {
          tabs: [
            {
              tabId: 1,
              tabCaption: 'Tab 1',
              blocks: {
                '1': {
                  componentType: 'Table',
                  title: 'Block 1',
                  url: '/v0/blocks/accountCredits?accountId=9955466',
                },
                '3': {
                  componentType: 'Table',
                  title: 'Block 2',
                  url: '/v0/blocks/accountDebts?accountId=9955466',
                },
              },
              layout: {
                schema: { rows: [{ areaId: '1', blockWidthRatio: 1 }] },
                areaIdToBlocksIds: { '1': ['1', '3'] },
              },
            },
            {
              tabId: 2,
              tabCaption: 'Tab 2',
              blocks: {
                '1': {
                  componentType: 'Table',
                  title: 'Block 3',
                  url: '/v0/blocks/accountCredits?accountId=9955466',
                },
                '3': {
                  componentType: 'Table',
                  title: 'Block 4',
                  url: '/v0/blocks/accountDebts?accountId=9955466',
                },
              },
              layout: {
                schema: { rows: [{ areaId: '1', blockWidthRatio: 1 }] },
                areaIdToBlocksIds: { '1': ['1', '3'] },
              },
            },
          ],
        },
      }),
    );
  }),
];
