/* eslint-disable camelcase */

import get from 'lodash/get';
import { createElement } from 'react';
import { connect } from 'react-redux';
import { getNewCall } from 'modules/phone/selectors';
import { CALL_HANDLING_TYPE } from 'modules/phone/constants';
import CallBar from './CallBar';

function CallBarContainer(props) {
  const { isActiveCall, ...passPropsThrough } = props;
  if (!isActiveCall) {
    return null;
  }

  return createElement(CallBar, passPropsThrough);
}

export default connect(state => {
  const { isAlreadySend, callData } = getNewCall(state) || {};

  let phoneNumber;
  try {
    const { call_handling_type } = callData;

    if (call_handling_type) {
      if (
        CALL_HANDLING_TYPE.INBOUND_DIRECT === call_handling_type ||
        CALL_HANDLING_TYPE.INBOUND_QUEUE === call_handling_type
      ) {
        phoneNumber = callData.caller_num;
      } else {
        phoneNumber = callData.called_to;
      }
    }
  } catch (e) {
    /* empty catch */
  }

  return {
    isActiveCall: !!callData,
    isAlreadySend,
    phoneNumber: get(state, 'root.info.showPhoneNumber') ? phoneNumber : undefined,
    startCallDate: callData && callData.ts,
    endCallDate: callData && callData.ts_end,
  };
})(CallBarContainer);
