import React from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import RequestLinkFromNewCall from './RequestLinkFromNewCall';
import NewMail from './NewMailContainer';
import CallForm from './CallForm';
import css from './CallCard.modules.scss';
import { CALL_FORM_NAME, CALL_MAIL_NAME } from '../../constants';
import History from '../History';
import CallerNameMacrosConstainer from './CallerNameMacrosConstainer';

const CallCard = (props) => {
  const { onSubmit, call = {}, isAlreadySend, isSend, autoFocus, account } = props;

  return (
    <div className={css.CallCard}>
      <History history={call.transferHistory} />
      <div>
        <CallForm
          form={CALL_FORM_NAME}
          access={get(call, 'uiPermissions.call')}
          initialValues={call.callInfo}
          enableReinitialize
          keepDirtyOnReinitialize
          autoFocus={autoFocus}
          account={account}
        />
      </div>
      <div className={css.CallCard__divide} />
      <NewMail
        className={css.CallCard__newMail}
        froms={call.froms}
        initialValues={{
          ...call.mail,
          from: '0',
        }}
        name={CALL_MAIL_NAME}
        buttonTextSend="Сохранить и отправить письмо"
        buttonTextSave="Сохранить"
        isShowCancel={false}
        onSubmit={onSubmit}
        disabledAll={isAlreadySend}
        disabledSend={isSend}
        renderExtraActions={() => <RequestLinkFromNewCall />}
        isLoad
        enableReinitialize
        keepDirtyOnReinitialize
        isSwitchSaveButtons
        objId={call.mail.id}
      />
      <CallerNameMacrosConstainer />
    </div>
  );
};

CallCard.propTypes = {
  onSubmit: PropTypes.func.isRequired,
  isAlreadySend: PropTypes.bool,
  isSend: PropTypes.bool,
  autoFocus: PropTypes.bool,
  call: PropTypes.instanceOf(Object),
};

CallCard.defaultProps = {
  call: {},
  isAlreadySend: false,
  isSend: false,
  autoFocus: false,
};

export default CallCard;
