import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { send } from 'modules/phone/redux/actions/newCall';
import { getNewCall, getIsSendNewCall } from 'modules/phone/selectors';
import CallCard from './CallCard';

const mapState = state => ({
  isAlreadySend: (getNewCall(state) || {}).isAlreadySend,
  isSend: getIsSendNewCall(state),
});

const mapDispatch = dispatch => ({
  onSubmit: bindActionCreators(send, dispatch),
});

export default connect(
  mapState,
  mapDispatch,
)(CallCard);
