import React from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import Mail from 'components/Mail';
import AccountLink from 'pages/accounts/components/AccountLink';
import cx from 'classnames';
import CallFormPreview from './CallFormPreview';
import css from './CallCard.modules.scss';

const CallCardPreview = (props) => {
  const { call } = props;

  if (!call) {
    return null;
  }

  const accountInfo = get(call, 'account.info');

  return (
    <div className={cx(css.CallCard, css.CallCard_preview)}>
      {
        accountInfo &&
        <div>
          <AccountLink account={accountInfo} />
        </div>
      }
      {
        call.callInfo &&
        <div>
          <CallFormPreview
            values={call.callInfo}
            access={get(call, 'uiPermissions.call')}
          />
        </div>
      }
      {
        call.mail &&
        <div className={css.CallCard__divide} />
      }
      {
        call.mail &&
        <Mail
          {...call.mail}
        />
      }
    </div>
  );
};

CallCardPreview.propTypes = {
  call: PropTypes.instanceOf(Object),
};

CallCardPreview.defaultProps = {
  call: undefined,
};

export default CallCardPreview;
